:- dec_p_type(max(int,int,int)).
max(X,Y,Z) :-
  X =< Y & Z = Y
  or
  Y < X & Z = X.

:- dec_p_type(min(int,int,int)).
min(X,Y,Z) :-
  X =< Y & Z = X
  or
  Y < X & Z = Y.

:- dec_p_type(mxlb_mnub(stype(int),int,stype(int),int,stype(int),int)).
mxlb_mnub(S,N,Lb,Max,Ub,Min) :-
  un(Lb,Ub,S) & disj(Lb,Ub) &
  (Max < N &
   Max in Lb &
   subset(Lb,int(_Min,Max)) & dec(_Min,int)
   or
   Lb = {}
  ) &
  (N < Min &
   Min in Ub &
   subset(Ub,int(Min,_Max)) & dec(_Max,int)
   or
   Ub = {}
  ).

:- dec_p_type(axdef(int,int)).
axdef(MinFlr,MaxFlr) :-
  MinFlr < MaxFlr.

:- dec_type(f,etype([flr,nxtFlr,door,cab,dir,req])).
:- dec_type(doort,etype([open,closed])).
:- dec_type(cabt,etype([moving,halted])).
:- dec_type(dirt,etype([up,down,none])).
:- dec_type(reqt,stype(int)).
:- dec_type(lift,[[f,int],[f,int],[f,doort],[f,cabt],[f,dirt],[f,reqt]]).

:- dec_p_type(liftInv1(lift)).
liftInv1(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  (D neq open
   or
   C = halted
  ).

:- dec_p_type(liftInv2(lift)).
liftInv2(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  (C neq moving
   or
   D = closed
  ).

:- dec_p_type(liftInv3(lift)).
liftInv3(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  (Di neq up
   or
   C neq moving
   or
   F =< Nf
  ).

:- dec_p_type(liftInv4(lift)).
liftInv4(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  (Di neq down
   or
   C neq moving
   or
   F >= Nf
  ).

:- dec_p_type(liftInv5(lift)).
liftInv5(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  Di in {up,down,none}.
 
:- dec_p_type(liftInv6(int,int,lift)).
liftInv6(MinF,MaxF,Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  axdef(MinF,MaxF) &
  MinF =< F &
  F =< MaxF.

:- dec_p_type(liftInv7(lift)).
liftInv7(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  (Nf nin R or F neq Nf).

:- dec_p_type(liftInit(int,int,lift)).
liftInit(MinF,MaxF,Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  axdef(MinF,MaxF) &
  F = MinF &
  Nf = MinF &
  D = open &
  C = halted &
  Di = none &
  R = {}.

:- dec_p_type(addRequest(int,int,lift,int,lift)).
addRequest(MinF,MaxF,Lift,F_i,Lift_) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & 
  dec([R,R_],reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  axdef(MinF,MaxF) &
  F_i neq F &
  MinF =< F_i &
  F_i =< MaxF &
  un(R,{F_i},R_) &
  Lift_ = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R_]].

:- dec_p_type(nextRequestNone(lift,lift)).
nextRequestNone(Lift,Lift_) :-
  dec([F,Nf,Nf_,Mx,Mn],int) & dec(D,doort) & dec(C,cabt) & dec([Di,Di_],dirt) &
  dec([R,R1,Lb,Ub],reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  Di = none &
  diff(R,{F},R1) &
  mxlb_mnub(R1,F,Lb,Mx,Ub,Mn) &
  (Lb neq {} &
   Nf_ = Mx & Di_ = down
   or
   Lb = {} & Ub neq {} &
   Nf_ = Mn & Di_ = up
   or
   Lb = {} & Ub = {} & Nf_ = Nf & Di_ = Di
  ) &
  Lift_ = [[flr,F],[nxtFlr,Nf_],[door,D],[cab,C],[dir,Di_],[req,R]].

:- dec_p_type(nextRequestUp(lift,lift)).
nextRequestUp(Lift,Lift_) :-
  dec([F,Nf,Nf_,_M],int) & dec(D,doort) & dec(C,cabt) & dec([Di,Di_],dirt) &
  dec([R,R1,_Lb,Ub],reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  Di = up &
  diff(R,{F},R1) &
  mxlb_mnub(R1,F,_Lb,_M,Ub,Nf_) &
  (Ub neq {} & Di_ = Di
   or
   Ub = {} & Nf_ = Nf & Di_ = none
  ) &
  Lift_ = [[flr,F],[nxtFlr,Nf_],[door,D],[cab,C],[dir,Di_],[req,R]].

:- dec_p_type(nextRequestDown(lift,lift)).
nextRequestDown(Lift,Lift_) :-
  dec([F,Nf,Nf_,_M],int) & dec(D,doort) & dec(C,cabt) & dec([Di,Di_],dirt) &
  dec([R,R1,Lb,_Ub],reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  Di = down &
  diff(R,{F},R1) &
  mxlb_mnub(R1,F,Lb,Nf_,_Ub,_M) &
  (Lb neq {} & Di_ = Di
   or
   Lb = {} & Nf_ = Nf & Di_ = none
  ) &
  Lift_ = [[flr,F],[nxtFlr,Nf_],[door,D],[cab,C],[dir,Di_],[req,R]].

:- dec_p_type(nextRequest(lift,lift)).
nextRequest(Lift,Lift_) :-
  nextRequestNone(Lift,Lift_)
  or
  nextRequestUp(Lift,Lift_)
  or
  nextRequestDown(Lift,Lift_).

:- dec_p_type(closeDoor(lift,lift)).
closeDoor(Lift,Lift_) :-
  dec([F,Nf],int) & dec([D,D_],doort) & dec(C,cabt) & dec(Di,dirt) & 
  dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  D = open &
  Nf neq F &
  D_ = closed &
  Lift_ = [[flr,F],[nxtFlr,Nf],[door,D_],[cab,C],[dir,Di],[req,R]].

:- dec_p_type(startLift(lift,lift)).
startLift(Lift,Lift_) :-
  dec([F,Nf],int) & dec(D,doort) & dec([C,C_],cabt) & dec([Di,Di_],dirt) &
  dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  C = halted &
  D = closed &
  F neq Nf &
  (Nf >= F
   or
   Di_ = down
  ) &
  (Nf =< F
   or
   Di_ = up
  ) &
  C_ = moving &
  Lift_ = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C_],[dir,Di_],[req,R]].

:- dec_p_type(passFloor(int,int,lift,lift)).
passFloor(MinF,MaxF,Lift,Lift_) :-
  dec([F,Nf,F_,F1,F2],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & 
  dec([R,R_],reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  axdef(MinF,MaxF) &
  F neq Nf &
  C = moving &
  Di in {up,down} &
  (Di neq up
   or
   F1 is F + 1 &
   min(F1,MaxF,F_)
  ) &
  (Di neq down
   or
   F2 is F - 1 &
   max(F2,MinF,F_)
  ) &
  (F_ neq Nf 
   or 
   R = {Nf/R_} & Nf nin R_
  ) &
  (F_ = Nf 
   or 
   R_ = R
  ) &
  Lift_ = [[flr,F_],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R_]].

:- dec_p_type(stopLift(lift,lift)).
stopLift(Lift,Lift_) :-
  dec([F,Nf],int) & dec(D,doort) & dec([C,C_],cabt) & dec(Di,dirt) & 
  dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  F = Nf &
  C = moving &
  C_ = halted &
  Lift_ = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C_],[dir,Di],[req,R]].

:- dec_p_type(openDoor(lift,lift)).
openDoor(Lift,Lift_) :-
  dec([F,Nf],int) & dec([D,D_],doort) & dec(C,cabt) & dec(Di,dirt) & 
  dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  C = halted &
  D = closed &
  D_ = open &
  Lift_ = [[flr,F],[nxtFlr,Nf],[door,D_],[cab,C],[dir,Di],[req,R]].

:- dec_p_type(sat_addRequest).
sat_addRequest :-
  dec([_MinF,_MaxF,_F_i],int) & dec([L,L_],lift) &
  addRequest(_MinF,_MaxF,L,_F_i,L_) &
  L_ neq L.

:- dec_p_type(sat_nextRequest).
sat_nextRequest :-
  dec([L,L_],lift) &
  nextRequest(L,L_) &
  L_ neq L.

:- dec_p_type(sat_closeDoor).
sat_closeDoor :-
  dec([L,L_],lift) &
  closeDoor(L,L_) &
  L_ neq L.

:- dec_p_type(sat_startLift).
sat_startLift :-
  dec([L,L_],lift) &
  startLift(L,L_) &
  L_ neq L.

:- dec_p_type(sat_passFloor).
sat_passFloor :-
  dec([_MinF,_MaxF,_F_i],int) & dec([L,L_],lift) &
  passFloor(_MinF,_MaxF,L,L_) &
  L_ neq L.

:- dec_p_type(sat_stopLift).
sat_stopLift :-
  dec([L,L_],lift) &
  stopLift(L,L_) &
  L_ neq L.

:- dec_p_type(sat_openDoor).
sat_openDoor :-
  dec([L,L_],lift) &
  openDoor(L,L_) &
  L_ neq L.

:- dec_p_type(check_satOp).
check_satOp :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking sat_addRequest...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     sat_addRequest &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking sat_nextRequest...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     sat_nextRequest! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking sat_closeDoor...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     sat_closeDoor! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking sat_startLift...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     sat_startLift! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking sat_passFloor...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     sat_passFloor! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking sat_stopLift...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     sat_stopLift! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking sat_openDoor...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     sat_openDoor! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(init_sat_inv1).
init_sat_inv1 :-
  dec([_MinF,_MaxF],int) & dec(Lift,lift) &
  liftInit(_MinF,_MaxF,Lift) &
  liftInv1(Lift).

:- dec_p_type(init_sat_inv2).
init_sat_inv2 :-
  dec([_MinF,_MaxF],int) & dec(Lift,lift) &
  liftInit(_MinF,_MaxF,Lift) &
  liftInv2(Lift).

:- dec_p_type(init_sat_inv3).
init_sat_inv3 :-
  dec([_MinF,_MaxF],int) & dec(Lift,lift) &
  liftInit(_MinF,_MaxF,Lift) &
  liftInv3(Lift).

:- dec_p_type(init_sat_inv4).
init_sat_inv4 :-
  dec([_MinF,_MaxF],int) & dec(Lift,lift) &
  liftInit(_MinF,_MaxF,Lift) &
  liftInv4(Lift).

:- dec_p_type(init_sat_inv5).
init_sat_inv5 :-
  dec([_MinF,_MaxF],int) & dec(Lift,lift) &
  liftInit(_MinF,_MaxF,Lift) &
  liftInv5(Lift).

:- dec_p_type(init_sat_inv6).
init_sat_inv6 :-
  dec([M1,M2],int) & dec(Lift,lift) &
  liftInit(M1,M2,Lift) &
  liftInv6(M1,M2,Lift).

:- dec_p_type(init_sat_inv7).
init_sat_inv7 :-
  dec([_MinF,_MaxF],int) & dec(Lift,lift) &
  liftInit(_MinF,_MaxF,Lift) &
  liftInv7(Lift).

:- dec_p_type(check_init_sat_inv).
check_init_sat_inv :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking init_sat_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     init_sat_inv1! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking init_sat_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     init_sat_inv2! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking init_sat_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     init_sat_inv3! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking init_sat_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     init_sat_inv4! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking init_sat_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     init_sat_inv5! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking init_sat_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     init_sat_inv6! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking init_sat_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     init_sat_inv7! &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(n_liftInv1(lift)).
n_liftInv1(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  D = open &
  C neq halted.

:- dec_p_type(n_liftInv2(lift)).
n_liftInv2(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  C = moving &
  D neq closed.

:- dec_p_type(n_liftInv3(lift)).
n_liftInv3(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  Di = up &
  C = moving &
  F > Nf.

:- dec_p_type(n_liftInv4(lift)).
n_liftInv4(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  Di = down &
  C = moving &
  F < Nf.

:- dec_p_type(n_liftInv5(lift)).
n_liftInv5(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  Di nin {up,down,none}.
 
:- dec_p_type(n_liftInv6(int,int,lift)).
n_liftInv6(MinF,MaxF,Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  axdef(MinF,MaxF) &
  (F < MinF
   or
   MaxF < F
  ).

:- dec_p_type(n_liftInv7(lift)).
n_liftInv7(Lift) :-
  dec([F,Nf],int) & dec(D,doort) & dec(C,cabt) & dec(Di,dirt) & dec(R,reqt) &
  Lift = [[flr,F],[nxtFlr,Nf],[door,D],[cab,C],[dir,Di],[req,R]] &
  (Nf in R & F = Nf).

:- dec_p_type(addRequest_PI_inv1).
addRequest_PI_inv1 :-
  dec([Lift,Lift_],lift) & dec([_MinF,_MaxF,_F_i],int) &
  liftInv1(Lift) &
  addRequest(_MinF,_MaxF,Lift,_F_i,Lift_) &
  n_liftInv1(Lift_).

:- dec_p_type(addRequest_PI_inv2).
addRequest_PI_inv2 :-
  dec([Lift,Lift_],lift) & dec([_MinF,_MaxF,_F_i],int) &
  liftInv2(Lift) &
  addRequest(_MinF,_MaxF,Lift,_F_i,Lift_) &
  n_liftInv2(Lift_).

:- dec_p_type(addRequest_PI_inv3).
addRequest_PI_inv3 :-
  dec([Lift,Lift_],lift) & dec([_MinF,_MaxF,_F_i],int) &
  liftInv3(Lift) &
  addRequest(_MinF,_MaxF,Lift,_F_i,Lift_) &
  n_liftInv3(Lift_).

:- dec_p_type(addRequest_PI_inv4).
addRequest_PI_inv4 :-
  dec([Lift,Lift_],lift) & dec([_MinF,_MaxF,_F_i],int) &
  liftInv4(Lift) &
  addRequest(_MinF,_MaxF,Lift,_F_i,Lift_) &
  n_liftInv4(Lift_).

:- dec_p_type(addRequest_PI_inv5).
addRequest_PI_inv5 :-
  dec([Lift,Lift_],lift) & dec([_MinF,_MaxF,_F_i],int) &
  liftInv5(Lift) &
  addRequest(_MinF,_MaxF,Lift,_F_i,Lift_) &
  n_liftInv5(Lift_).

:- dec_p_type(addRequest_PI_inv6).
addRequest_PI_inv6 :-
  dec([Lift,Lift_],lift) & dec([M1,M2,_F_i],int) &
  liftInv6(M1,M2,Lift) &
  addRequest(M1,M2,Lift,_F_i,Lift_) &
  n_liftInv6(M1,M2,Lift_).

:- dec_p_type(addRequest_PI_inv7).
addRequest_PI_inv7 :-
  dec([Lift,Lift_],lift) & dec([_MinF,_MaxF,_F_i],int) &
  liftInv7(Lift) &
  addRequest(_MinF,_MaxF,Lift,_F_i,Lift_) &
  n_liftInv7(Lift_).

:- dec_p_type(check_addRequest_PI).
check_addRequest_PI :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking addRequest_PI_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(addRequest_PI_inv1) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking addRequest_PI_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(addRequest_PI_inv2) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking addRequest_PI_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(addRequest_PI_inv3) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking addRequest_PI_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(addRequest_PI_inv4) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking addRequest_PI_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(addRequest_PI_inv5) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking addRequest_PI_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(addRequest_PI_inv6) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking addRequest_PI_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(addRequest_PI_inv7) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(nextRequest_PI_inv1).
nextRequest_PI_inv1 :-
  dec([Lift,Lift_],lift) &
  liftInv1(Lift) &
  nextRequest(Lift,Lift_) &
  n_liftInv1(Lift_).

:- dec_p_type(nextRequest_PI_inv2).
nextRequest_PI_inv2 :-
  dec([Lift,Lift_],lift) &
  liftInv2(Lift) &
  nextRequest(Lift,Lift_) &
  n_liftInv2(Lift_).

:- dec_p_type(nextRequest_PI_inv3).
nextRequest_PI_inv3 :-
  dec([Lift,Lift_],lift) &
  liftInv3(Lift) &
  nextRequest(Lift,Lift_) &
  n_liftInv3(Lift_).

:- dec_p_type(nextRequest_PI_inv4).
nextRequest_PI_inv4 :-
  dec([Lift,Lift_],lift) &
  liftInv4(Lift) &
  nextRequest(Lift,Lift_) &
  n_liftInv4(Lift_).

:- dec_p_type(nextRequest_PI_inv5).
nextRequest_PI_inv5 :-
  dec([Lift,Lift_],lift) &
  liftInv5(Lift) &
  nextRequest(Lift,Lift_) &
  n_liftInv5(Lift_).

:- dec_p_type(nextRequest_PI_inv6).
nextRequest_PI_inv6 :-
  dec([Lift,Lift_],lift) & dec([M1,M2],int) &
  liftInv6(M1,M2,Lift) &
  nextRequest(Lift,Lift_) &
  n_liftInv6(M1,M2,Lift_).

:- dec_p_type(nextRequest_PI_inv7).
nextRequest_PI_inv7 :-
  dec([Lift,Lift_],lift) &
  liftInv7(Lift) &
  nextRequest(Lift,Lift_) &
  n_liftInv7(Lift_).

:- dec_p_type(check_nextRequest_PI).
check_nextRequest_PI :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking nextRequest_PI_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(nextRequest_PI_inv1) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking nextRequest_PI_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(nextRequest_PI_inv2) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking nextRequest_PI_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(nextRequest_PI_inv3) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking nextRequest_PI_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(nextRequest_PI_inv4) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking nextRequest_PI_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(nextRequest_PI_inv5) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking nextRequest_PI_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(nextRequest_PI_inv6) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking nextRequest_PI_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(nextRequest_PI_inv7) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(closeDoor_PI_inv1).
closeDoor_PI_inv1 :-
  dec([Lift,Lift_],lift) &
  liftInv1(Lift) &
  closeDoor(Lift,Lift_) &
  n_liftInv1(Lift_).

:- dec_p_type(closeDoor_PI_inv2).
closeDoor_PI_inv2 :-
  dec([Lift,Lift_],lift) &
  liftInv2(Lift) &
  closeDoor(Lift,Lift_) &
  n_liftInv2(Lift_).

:- dec_p_type(closeDoor_PI_inv3).
closeDoor_PI_inv3 :-
  dec([Lift,Lift_],lift) &
  liftInv3(Lift) &
  closeDoor(Lift,Lift_) &
  n_liftInv3(Lift_).

:- dec_p_type(closeDoor_PI_inv4).
closeDoor_PI_inv4 :-
  dec([Lift,Lift_],lift) &
  liftInv4(Lift) &
  closeDoor(Lift,Lift_) &
  n_liftInv4(Lift_).

:- dec_p_type(closeDoor_PI_inv5).
closeDoor_PI_inv5 :-
  dec([Lift,Lift_],lift) &
  liftInv5(Lift) &
  closeDoor(Lift,Lift_) &
  n_liftInv5(Lift_).

:- dec_p_type(closeDoor_PI_inv6).
closeDoor_PI_inv6 :-
  dec([Lift,Lift_],lift) & dec([M1,M2],int) &
  liftInv6(M1,M2,Lift) &
  closeDoor(Lift,Lift_) &
  n_liftInv6(M1,M2,Lift_).

:- dec_p_type(closeDoor_PI_inv7).
closeDoor_PI_inv7 :-
  dec([Lift,Lift_],lift) &
  liftInv7(Lift) &
  closeDoor(Lift,Lift_) &
  n_liftInv7(Lift_).

:- dec_p_type(check_closeDoor_PI).
check_closeDoor_PI :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking closeDoor_PI_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(closeDoor_PI_inv1) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking closeDoor_PI_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(closeDoor_PI_inv2) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking closeDoor_PI_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(closeDoor_PI_inv3) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking closeDoor_PI_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(closeDoor_PI_inv4) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking closeDoor_PI_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(closeDoor_PI_inv5) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking closeDoor_PI_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(closeDoor_PI_inv6) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking closeDoor_PI_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(closeDoor_PI_inv7) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(startLift_PI_inv1).
startLift_PI_inv1 :-
  dec([Lift,Lift_],lift) &
  liftInv1(Lift) &
  startLift(Lift,Lift_) &
  n_liftInv1(Lift_).

:- dec_p_type(startLift_PI_inv2).
startLift_PI_inv2 :-
  dec([Lift,Lift_],lift) &
  liftInv2(Lift) &
  startLift(Lift,Lift_) &
  n_liftInv2(Lift_).

:- dec_p_type(startLift_PI_inv3).
startLift_PI_inv3 :-
  dec([Lift,Lift_],lift) &
  liftInv3(Lift) &
  startLift(Lift,Lift_) &
  n_liftInv3(Lift_).

:- dec_p_type(startLift_PI_inv4).
startLift_PI_inv4 :-
  dec([Lift,Lift_],lift) &
  liftInv4(Lift) &
  startLift(Lift,Lift_) &
  n_liftInv4(Lift_).

:- dec_p_type(startLift_PI_inv5).
startLift_PI_inv5 :-
  dec([Lift,Lift_],lift) &
  liftInv5(Lift) &
  startLift(Lift,Lift_) &
  n_liftInv5(Lift_).

:- dec_p_type(startLift_PI_inv6).
startLift_PI_inv6 :-
  dec([Lift,Lift_],lift) & dec([M1,M2],int) &
  liftInv6(M1,M2,Lift) &
  startLift(Lift,Lift_) &
  n_liftInv6(M1,M2,Lift_).

:- dec_p_type(startLift_PI_inv7).
startLift_PI_inv7 :-
  dec([Lift,Lift_],lift) &
  liftInv7(Lift) &
  startLift(Lift,Lift_) &
  n_liftInv7(Lift_).

:- dec_p_type(check_startLift_PI).
check_startLift_PI :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking startLift_PI_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(startLift_PI_inv1) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking startLift_PI_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(startLift_PI_inv2) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking startLift_PI_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(startLift_PI_inv3) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking startLift_PI_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(startLift_PI_inv4) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking startLift_PI_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(startLift_PI_inv5) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking startLift_PI_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(startLift_PI_inv6) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking startLift_PI_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(startLift_PI_inv7) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(passFloor_PI_inv1).
passFloor_PI_inv1 :-
  dec([Lift,Lift_],lift) & dec([_M1,_M2],int) &
  liftInv1(Lift) &
  passFloor(_M1,_M2,Lift,Lift_) &
  n_liftInv1(Lift_).

:- dec_p_type(passFloor_PI_inv2).
passFloor_PI_inv2 :-
  dec([Lift,Lift_],lift) & dec([_M1,_M2],int) &
  liftInv2(Lift) &
  passFloor(_M1,_M2,Lift,Lift_) &
  n_liftInv2(Lift_).

:- dec_p_type(passFloor_PI_inv3).
passFloor_PI_inv3 :-
  dec([Lift,Lift_],lift) & dec([_M1,_M2],int) &
  liftInv3(Lift) &
  passFloor(_M1,_M2,Lift,Lift_) &
  n_liftInv3(Lift_).

:- dec_p_type(passFloor_PI_inv4).
passFloor_PI_inv4 :-
  dec([Lift,Lift_],lift) & dec([_M1,_M2],int) &
  liftInv4(Lift) &
  passFloor(_M1,_M2,Lift,Lift_) &
  n_liftInv4(Lift_).

:- dec_p_type(passFloor_PI_inv5).
passFloor_PI_inv5 :-
  dec([Lift,Lift_],lift) & dec([_M1,_M2],int) &
  liftInv5(Lift) &
  passFloor(_M1,_M2,Lift,Lift_) &
  n_liftInv5(Lift_).

:- dec_p_type(passFloor_PI_inv6).
passFloor_PI_inv6 :-
  dec([Lift,Lift_],lift) & dec([M1,M2],int) &
  liftInv5(Lift) &
  liftInv6(M1,M2,Lift) &
  passFloor(M1,M2,Lift,Lift_) &
  n_liftInv6(M1,M2,Lift_).

:- dec_p_type(passFloor_PI_inv7).
passFloor_PI_inv7 :-
  dec([Lift,Lift_],lift) & dec([_M1,_M2],int) &
  liftInv7(Lift) &
  passFloor(_M1,_M2,Lift,Lift_) &
  n_liftInv7(Lift_).

:- dec_p_type(check_passFloor_PI).
check_passFloor_PI :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking passFloor_PI_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(passFloor_PI_inv1) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking passFloor_PI_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(passFloor_PI_inv2) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking passFloor_PI_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(passFloor_PI_inv3) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking passFloor_PI_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(passFloor_PI_inv4) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking passFloor_PI_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(passFloor_PI_inv5) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking passFloor_PI_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(passFloor_PI_inv6) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking passFloor_PI_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(passFloor_PI_inv7) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(stopLift_PI_inv1).
stopLift_PI_inv1 :-
  dec([Lift,Lift_],lift) &
  liftInv1(Lift) &
  stopLift(Lift,Lift_) &
  n_liftInv1(Lift_).

:- dec_p_type(stopLift_PI_inv2).
stopLift_PI_inv2 :-
  dec([Lift,Lift_],lift) &
  liftInv2(Lift) &
  stopLift(Lift,Lift_) &
  n_liftInv2(Lift_).

:- dec_p_type(stopLift_PI_inv3).
stopLift_PI_inv3 :-
  dec([Lift,Lift_],lift) &
  liftInv3(Lift) &
  stopLift(Lift,Lift_) &
  n_liftInv3(Lift_).

:- dec_p_type(stopLift_PI_inv4).
stopLift_PI_inv4 :-
  dec([Lift,Lift_],lift) &
  liftInv4(Lift) &
  stopLift(Lift,Lift_) &
  n_liftInv4(Lift_).

:- dec_p_type(stopLift_PI_inv5).
stopLift_PI_inv5 :-
  dec([Lift,Lift_],lift) &
  liftInv5(Lift) &
  stopLift(Lift,Lift_) &
  n_liftInv5(Lift_).

:- dec_p_type(stopLift_PI_inv6).
stopLift_PI_inv6 :-
  dec([Lift,Lift_],lift) & dec([M1,M2],int) &
  liftInv6(M1,M2,Lift) &
  stopLift(Lift,Lift_) &
  n_liftInv6(M1,M2,Lift_).

:- dec_p_type(stopLift_PI_inv7).
stopLift_PI_inv7 :-
  dec([Lift,Lift_],lift) &
  liftInv7(Lift) &
  stopLift(Lift,Lift_) &
  n_liftInv7(Lift_).

:- dec_p_type(check_stopLift_PI).
check_stopLift_PI :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking stopLift_PI_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(stopLift_PI_inv1) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking stopLift_PI_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(stopLift_PI_inv2) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking stopLift_PI_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(stopLift_PI_inv3) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking stopLift_PI_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(stopLift_PI_inv4) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking stopLift_PI_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(stopLift_PI_inv5) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking stopLift_PI_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(stopLift_PI_inv6) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking stopLift_PI_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(stopLift_PI_inv7) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(openDoor_PI_inv1).
openDoor_PI_inv1 :-
  dec([Lift,Lift_],lift) &
  liftInv1(Lift) &
  openDoor(Lift,Lift_) &
  n_liftInv1(Lift_).

:- dec_p_type(openDoor_PI_inv2).
openDoor_PI_inv2 :-
  dec([Lift,Lift_],lift) &
  liftInv2(Lift) &
  openDoor(Lift,Lift_) &
  n_liftInv2(Lift_).

:- dec_p_type(openDoor_PI_inv3).
openDoor_PI_inv3 :-
  dec([Lift,Lift_],lift) &
  liftInv3(Lift) &
  openDoor(Lift,Lift_) &
  n_liftInv3(Lift_).

:- dec_p_type(openDoor_PI_inv4).
openDoor_PI_inv4 :-
  dec([Lift,Lift_],lift) &
  liftInv4(Lift) &
  openDoor(Lift,Lift_) &
  n_liftInv4(Lift_).

:- dec_p_type(openDoor_PI_inv5).
openDoor_PI_inv5 :-
  dec([Lift,Lift_],lift) &
  liftInv5(Lift) &
  openDoor(Lift,Lift_) &
  n_liftInv5(Lift_).

:- dec_p_type(openDoor_PI_inv6).
openDoor_PI_inv6 :-
  dec([Lift,Lift_],lift) & dec([M1,M2],int) &
  liftInv6(M1,M2,Lift) &
  openDoor(Lift,Lift_) &
  n_liftInv6(M1,M2,Lift_).

:- dec_p_type(openDoor_PI_inv7).
openDoor_PI_inv7 :-
  dec([Lift,Lift_],lift) &
  liftInv7(Lift) &
  openDoor(Lift,Lift_) &
  n_liftInv7(Lift_).

:- dec_p_type(check_openDoor_PI).
check_openDoor_PI :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking openDoor_PI_inv1...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(openDoor_PI_inv1) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking openDoor_PI_inv2...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(openDoor_PI_inv2) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking openDoor_PI_inv3...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(openDoor_PI_inv3) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking openDoor_PI_inv4...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(openDoor_PI_inv4) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking openDoor_PI_inv5...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(openDoor_PI_inv5) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking openDoor_PI_inv6...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(openDoor_PI_inv6) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking openDoor_PI_inv7...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(openDoor_PI_inv7) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).

:- dec_p_type(check_inv).
check_inv :-
  dec([PO,NPO],int) &
  prolog_call((get_time(Ti),nb_setval(po,0))) &
  (nl & write('Checking check_addRequest_PI...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(check_addRequest_PI) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking check_nextRequest_PI...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(check_nextRequest_PI) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking check_closeDoor_PI...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(check_closeDoor_PI) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking check_startLift_PI...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(check_startLift_PI) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking check_passFloor_PI...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(check_passFloor_PI) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking check_stopLift_PI...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(check_stopLift_PI) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   nl & write('Checking check_openDoor_PI...') & 
     prolog_call((nb_getval(po,PO),flush_output)) & NPO is PO+1 &
     naf(check_openDoor_PI) &
     write('OK ') & prolog_call((nb_setval(po,NPO),flush_output,fail)) or
   prolog_call((get_time(Te),nb_getval(po,PO),T is Te - Ti)) &
     nl & nl & write(PO) & write(' sets of proof obligations discharged in ') &
     write(T) & write(' seconds') & nl
  ).


